/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// "Balloon Dance" by dr2 - 2016
// License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License

float Noisefv3 (vec3 p);
float Fbm2 (vec2 p);
float PrSphDf (vec3 p, float s);
float PrCylDf (vec3 p, float r, float h);
float SmoothBump (float lo, float hi, float w, float x);
vec2 Rot2D (vec2 q, float a);
vec3 HsvToRgb (vec3 c);

const float pi = 3.14159;

#define N_BAL 5

vec3 balPos[N_BAL], sunDir, qHit, qHitFlm;
float dstFar, tCur, balRad, flmCylRad, flmCylLen;
int idObj, idGrp;
bool balFlm[N_BAL], balFlmCur;

vec3 BgCol (vec3 ro, vec3 rd)
{
  vec3 col, skyCol, sunCol, p;
  float ds, fd, att, attSum, d, sd;
  if (rd.y >= 0.) {
    p = rd * (200. - ro.y) / max (rd.y, 0.0001);
    ds = 0.1 * sqrt (length (p));
    p += ro;
    fd = 0.002 / (smoothstep (0., 10., ds) + 0.1);
    p.xz *= fd;
    p.xz += 0.1 * tCur;
    att = Fbm2 (p.xz);
    attSum = att;
    d = fd;
    ds *= fd;
    for (int j = 0; j < 4; j ++) {
      attSum += Fbm2 (p.xz + d * sunDir.xz);
      d += ds;
    }
    attSum *= 0.3;
    att *= 0.3;
    sd = clamp (dot (sunDir, rd), 0., 1.);
    skyCol = mix (vec3 (0.7, 1., 1.), vec3 (1., 0.4, 0.1), 0.25 + 0.75 * sd);
    sunCol = vec3 (1., 0.8, 0.7) * pow (sd, 1024.) +
       vec3 (1., 0.4, 0.2) * pow (sd, 256.);
    col = mix (vec3 (0.5, 0.75, 1.), skyCol, exp (-2. * (3. - sd) *
       max (rd.y - 0.1, 0.))) + 0.3 * sunCol;
    attSum = 1. - smoothstep (1., 9., attSum);
    col = mix (vec3 (0.4, 0., 0.2), mix (col, vec3 (0.3, 0.3, 0.3), att), attSum) +
       vec3 (1., 0.4, 0.) * pow (attSum * att, 3.) * (pow (sd, 10.) + 0.5);
  } else col = vec3 (0.1, 0.2, 0.1);
  return col;
}

float FlmDf (vec3 p)
{
  vec3 q;
  float d, dMin;
  dMin = dstFar;
  for (int k = 0; k < N_BAL; k ++) {
    if (balFlm[k]) {
      q = p - (balPos[k] - vec3 (0., 0.8 * balRad, 0.));
      d = PrCylDf (q.xzy, flmCylRad + 0.3 * q.y / flmCylLen, flmCylLen);
      d = max (d, - q.y - 0.5 * flmCylLen);
      if (d < dMin) { dMin = d;  qHitFlm = q; }
    }
  }
  return dMin;
}

float FlmRay (vec3 ro, vec3 rd)
{
  float dHit, d;
  dHit = 0.;
  for (int j = 0; j < 100; j ++) {
    d = FlmDf (ro + dHit * rd);
    dHit += d;
    if (d < 0.001 || dHit > dstFar) break;
  }
  if (d >= 0.001) dHit = dstFar;
  return dHit;
}

float BalDf (vec3 p, float dMin)
{
  vec3 q;
  float d;
  q = p;
  d = max (PrSphDf (q, balRad), - PrSphDf (q, 0.98 * balRad));
  q.y -= - balRad;
  d = max (d, - PrCylDf (q.xzy, 0.3 * balRad, 0.1 * balRad));
  if (d < dMin) { dMin = d;  idObj = 1;  qHit = p;}
  q = p;
  q.y -= -1.42 * balRad;
  d = PrCylDf (q.xzy, 0.05 * balRad, 0.13 * balRad);
  q.y -= 0.02 * balRad;
  d = max (d, - PrCylDf (q.xzy, 0.03 * balRad, 0.13 * balRad));
  if (d < dMin) { dMin = d;  idObj = 2;  qHit = p;}
  q = p;
  q.y -= -1.5 * balRad;
  d = PrCylDf (q.xzy, 0.2 * balRad, 0.07 * balRad);
  q.y -= 0.02 * balRad;
  d = max (d, - PrCylDf (q.xzy, 0.18 * balRad, 0.07 * balRad));
  if (d < dMin) { dMin = d;  idObj = 3;  qHit = p;}
  q = p;
  q.xz = abs (q.xz) - 0.25 * balRad;
  q.y -= -1.15 * balRad;
  q.yz = Rot2D (q.yz, -0.35);
  q.xy = Rot2D (q.xy, 0.35);
  d = PrCylDf (q.xzy, 0.005 * balRad, 0.35 * balRad);
  if (d < dMin) { dMin = d;  idObj = 4;  qHit = p;}
  return dMin;
}

float ObjDf (vec3 p)
{
  float dMin, d;
  dMin = dstFar;
  for (int k = 0; k < N_BAL; k ++) {
    d = BalDf (p - balPos[k], dMin);
    if (d < dMin) { dMin = d;  idGrp = k;  balFlmCur = balFlm[k]; }
  }
  return dMin;
}

float ObjRay (vec3 ro, vec3 rd)
{
  float dHit, d;
  dHit = 0.;
  for (int j = 0; j < 100; j ++) {
    d = ObjDf (ro + dHit * rd);
    dHit += d;
    if (d < 0.001 || dHit > dstFar) break;
  }
  return dHit;
}

vec3 ObjNf (vec3 p)
{
  vec4 v;
  vec3 e = vec3 (0.001, -0.001, 0.);
  v = vec4 (ObjDf (p + e.xxx), ObjDf (p + e.xyy),
     ObjDf (p + e.yxy), ObjDf (p + e.yyx));
  return normalize (vec3 (v.x - v.y - v.z - v.w) + 2. * vec3 (v.y, v.z, v.w));
}

vec3 FlmCol (vec3 p, vec3 rd)
{
  vec3 q, qq;
  float a, f, dr;
  a = 0.;
  p.y -= - flmCylLen;
  dr = 0.05 / flmCylRad;
  for (int j = 0; j < 20; j ++) {
    p += dr * rd;
    q = 15. * p / flmCylLen;
    q.y -= 40. * tCur;
    qq.y = Noisefv3 (q + 0.1 * vec3 (sin (tCur)));
    qq.x = Noisefv3 (q + vec3 (qq.y));
    qq.z = Noisefv3 (q + vec3 (qq.x));
    q = p + 0.25 * (1. - 3. * p.y / flmCylLen) * (qq - 0.5);
    f = 0.45 * q.y - 2.5 * length (q.xz);
    f = clamp (sign (f) * f * f, 0., 1.) * (3. - 0.9 * q.y);
    a += f;
  }
  return clamp (a * vec3 (1., 0.5, 0.3), 0., 1.);
}

vec3 ShowScene (vec3 ro, vec3 rd)
{
  vec3 vn, col, colFlm;
  float dstObj, dstFlm, a, s;
  bool inSun, inFlm;
  for (int k = 0; k < N_BAL; k ++) {
    s = float (k - 1) / float (N_BAL);
    a = 2. * pi * fract (0.02 * tCur + s);
    balPos[k].xz = 2.5 * balRad * vec2 (cos (a), sin (a));
    a = 2. * pi * fract (0.07 * tCur + s);
    balPos[k].y = 3. * balRad + 0.5 * balRad * sin (a);
    balFlm[k] = (a > pi);
  }
  flmCylRad = 0.4;
  flmCylLen = 2.;
  dstFlm = FlmRay (ro, rd);
  dstObj = ObjRay (ro, rd);
  inSun = true;
  inFlm = false;
  if (dstObj < dstFar) {
    ro += rd * dstObj;
    vn = ObjNf (ro);
    if (idObj == 1) {
      col = HsvToRgb (vec3 (float (idGrp) / float (N_BAL), 0.9, 0.8));
      col *= 1. + 0.2 * SmoothBump (0.17, 0.25, 0.02,
         min (length (qHit.xy), length (qHit.zy)) / balRad);
      inFlm = balFlmCur;
      if (length (qHit) < 0.99 * balRad) {
        col *= 0.2;
        if (inFlm) col += 0.1 * vec3 (1., 0.5, 0.);
        inSun = false;
      } else {
        if (length (qHit) > 0.99 * balRad) {
          a = atan (qHit.x, qHit.z) / (2. * pi) + 0.5;
          vn.xz = Rot2D (vn.xz, 0.1 * pi * sin (pi * (0.5 - mod (24. * a, 1.))));
        }
      }
    } else if (idObj == 2) {
       a = atan (qHit.x, qHit.z) / (2. * pi) + 0.5;
       vn.xz = Rot2D (vn.xz, 0.1 * pi * sin (pi * (0.5 - mod (12. * a, 1.))));
      col = vec3 (0.6);
    } else if (idObj == 3) {
      a = atan (qHit.x, qHit.z) / (2. * pi) + 0.5;
      vn.xz = Rot2D (vn.xz, 0.1 * pi * sin (pi * (0.5 - mod (32. * a, 1.))));
      col = vec3 (0.6, 0.3, 0.);
    } else if (idObj == 4) {
      col = vec3 (0.3);
    }
    if (inSun) col = col * (0.2 +
       0.2 * max (dot (vn, - normalize (vec3 (sunDir.x, 0., sunDir.z))), 0.) +
       0.6 * max (dot (vn, sunDir), 0.)) +
       0.1 * pow (max (0., dot (sunDir, reflect (rd, vn))), 64.);
  } else col = BgCol (ro, rd);
  if (dstFlm < min (dstFar, dstObj)) {
    colFlm = FlmCol (qHitFlm, rd);
    col = mix (col, colFlm, 0.6 * length (colFlm));
  }
  if (inFlm) col = mix (col, vec3 (1., 0.5, 0.),
     0.3 * pow (clamp (dot (normalize (qHit), - rd), 0., 1.), 4.));
  return clamp (col, 0., 1.);
}

void mainImage (out vec4 fragColor, in vec2 fragCoord)
{
  vec3 ro, rd, vd, u;
  vec2 canvas, uv, ori, ca, sa;
  float el, az, f;
  canvas = iResolution.xy;
  uv = 2. * fragCoord.xy / canvas - 1.;
  uv.x *= canvas.x / canvas.y;
  tCur = iGlobalTime;
  dstFar = 50.;
  balRad = 2.;
  az = 2. * pi * fract (0.01 * tCur);
  el = 0.1 * pi + 0.08 * pi * sin (2. * pi * fract (0.022 * tCur));
  ori = vec2 (el, az);
  ca = cos (ori);
  sa = sin (ori);
  ro = mat3 (ca.y, 0., - sa.y, 0., 1., 0., sa.y, 0., ca.y) *
       mat3 (1., 0., 0., 0., ca.x, - sa.x, 0., sa.x, ca.x) *
      vec3 (0., 2., -30.);
  vd = normalize (vec3 (0., 3. * balRad, 0.) - ro);
  u = - vd.y * vd;
  f = 1. / sqrt (1. - vd.y * vd.y);
  rd = mat3 (f * vec3 (vd.z, 0., - vd.x), f * vec3 (u.x, 1. + u.y, u.z), vd) *
     normalize (vec3 (uv, 5.5));
  sunDir = normalize (vec3 (1., 0.2, -1.));
  fragColor = vec4 (ShowScene (ro, rd), 1.);
}

float PrSphDf (vec3 p, float s)
{
  return length (p) - s;
}

float PrCylDf (vec3 p, float r, float h)
{
  return max (length (p.xy) - r, abs (p.z) - h);
}

float SmoothBump (float lo, float hi, float w, float x)
{
  return (1. - smoothstep (hi - w, hi + w, x)) * smoothstep (lo - w, lo + w, x);
}

vec2 Rot2D (vec2 q, float a)
{
  return q * cos (a) + q.yx * sin (a) * vec2 (-1., 1.);
}

vec3 HsvToRgb (vec3 c)
{
  vec3 p = abs (fract (c.xxx + vec3 (1., 2./3., 1./3.)) * 6. - 3.);
  return c.z * mix (vec3 (1.), clamp (p - 1., 0., 1.), c.y);
}

const vec4 cHashA4 = vec4 (0., 1., 57., 58.);
const vec3 cHashA3 = vec3 (1., 57., 113.);
const float cHashM = 43758.54;

vec4 Hashv4f (float p)
{
  return fract (sin (p + cHashA4) * cHashM);
}

float Noisefv2 (vec2 p)
{
  vec4 t;
  vec2 ip, fp;
  ip = floor (p);
  fp = fract (p);
  fp = fp * fp * (3. - 2. * fp);
  t = Hashv4f (dot (ip, cHashA3.xy));
  return mix (mix (t.x, t.y, fp.x), mix (t.z, t.w, fp.x), fp.y);
}

float Noisefv3 (vec3 p)
{
  vec4 t1, t2;
  vec3 ip, fp;
  float q;
  ip = floor (p);
  fp = fract (p);
  fp = fp * fp * (3. - 2. * fp);
  q = dot (ip, cHashA3);
  t1 = Hashv4f (q);
  t2 = Hashv4f (q + cHashA3.z);
  return mix (mix (mix (t1.x, t1.y, fp.x), mix (t1.z, t1.w, fp.x), fp.y),
              mix (mix (t2.x, t2.y, fp.x), mix (t2.z, t2.w, fp.x), fp.y), fp.z);
}

float Fbm2 (vec2 p)
{
  float f, a;
  f = 0.;
  a = 1.;
  for (int i = 0; i < 5; i ++) {
    f += a * Noisefv2 (p);
    a *= 0.5;
    p *= 2.;
  }
  return f;
}

void main ( void )
{
   mainImage ( gl_FragColor, gl_FragCoord.xy );
} 
